/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.database;

import java.util.Collection;
import java.util.HashMap;
import oracle.cluster.verification.database.DatabaseConnectInfoException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DatabaseConnectInfo {
    private static HashMap<String, DatabaseConnectInfo> m_mapDBConnectInfo = new HashMap();
    protected static MessageBundle m_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String m_dbUniqueName = null;
    private String m_userName = "DBSNMP";
    private String m_userPassword = null;
    private int m_listenerPort = 0;

    public DatabaseConnectInfo(String dbUniqueName, String userPassword) {
        this.m_dbUniqueName = dbUniqueName;
        this.m_userPassword = userPassword;
    }

    public DatabaseConnectInfo(String dbUniqueName, String dbUserName, String userPassword) {
        this.m_dbUniqueName = dbUniqueName;
        this.m_userName = dbUserName;
        this.m_userPassword = userPassword;
    }

    public DatabaseConnectInfo(String dbUniqueName, String userPassword, int listenerPort) {
        this.m_dbUniqueName = dbUniqueName;
        this.m_userPassword = userPassword;
        this.m_listenerPort = listenerPort;
    }

    public DatabaseConnectInfo(String dbUniqueName, String dbUserName, String userPassword, int listenerPort) {
        this.m_dbUniqueName = dbUniqueName;
        this.m_userName = dbUserName;
        this.m_userPassword = userPassword;
        this.m_listenerPort = listenerPort;
    }

    public static Collection<DatabaseConnectInfo> getDatabaseConnectInfos() throws DatabaseConnectInfoException {
        Collection<DatabaseConnectInfo> dbConnInfos = m_mapDBConnectInfo.values();
        if (dbConnInfos.size() == 0) {
            Trace.out((String)"No DatabaseConnectInfo objects. throwing internal exception");
            throw new DatabaseConnectInfoException(m_msgBundle, "7508", new Object[0]);
        }
        return dbConnInfos;
    }

    public final String dbUniqueName() {
        return this.m_dbUniqueName;
    }

    public final String userName() {
        return this.m_userName;
    }

    public final String userPassword() {
        return this.m_userPassword;
    }

    public final int listenerPort() {
        return this.m_listenerPort;
    }

    public String toString() {
        String str = null;
        str = this.m_listenerPort == 0 ? "(dnName, userName, listener Port) = (" + this.m_dbUniqueName + ", " + this.m_userName + ", NONE)" : "(dnName, userName, listener Port) =  (" + this.m_dbUniqueName + ", " + this.m_userName + ", " + this.m_listenerPort + ")";
        return str;
    }

    public static DatabaseConnectInfo getDBConnectInfo(String dbUniqueName) {
        return m_mapDBConnectInfo.get(dbUniqueName);
    }

    public static void addDBConnectInfo(DatabaseConnectInfo dbConnectInfo) {
        m_mapDBConnectInfo.put(dbConnectInfo.dbUniqueName(), dbConnectInfo);
    }
}

